<?php
/* --------------------------------------------------------------
 Configuration.php 2019-10-18
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Configuration\Models\Read;

/**
 * Class Configuration
 * @package Gambio\Core\Configuration\Models
 */
class ConfigurationGroupItem
{
    public const LABEL      = 'label';
    public const PROPERTIES = 'properties';
    public const TYPE       = 'type';
    
    /**
     * @var ConfigurationGroupItemLabel
     */
    private $label;
    
    /**
     * @var ConfigurationGroupItemProperties
     */
    private $properties;
    
    /**
     * @var string
     */
    private $type;
    
    
    /**
     * Configuration constructor.
     *
     * @param ConfigurationGroupItemLabel      $label
     * @param ConfigurationGroupItemProperties $properties
     * @param string                           $type
     */
    private function __construct(
        ConfigurationGroupItemLabel $label,
        ConfigurationGroupItemProperties $properties,
        string $type
    ) {
        $this->label      = $label;
        $this->properties = $properties;
        $this->type       = $type;
    }
    
    
    /**
     * Factory method for Configuration.
     *
     * @param ConfigurationGroupItemLabel      $label
     * @param ConfigurationGroupItemProperties $properties
     * @param string                           $type
     *
     * @return ConfigurationGroupItem
     */
    public static function create(
        ConfigurationGroupItemLabel $label,
        ConfigurationGroupItemProperties $properties,
        string $type
    ): self {
        return new static($label, $properties, $type);
    }
    
    
    /**
     * Array serialization.
     *
     * @return array
     */
    public function toArray(): array
    {
        return [
            self::LABEL      => $this->label->toArray(),
            self::PROPERTIES => $this->properties->toArray(),
            self::TYPE       => $this->type,
        ];
    }
    
    
    /**
     * Returns properties data (key value pair).
     *
     * @return array
     */
    public function properties(): array
    {
        return $this->properties->toArray();
    }
}